<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Controller dello storico operazioni
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/GestoreStoricoOperazioni.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni", 1);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
    }
    
    $gestoreStoricoOperazioni = new GestoreStoricoOperazioni($geecomDb,"Admin");
    
    switch ($operazione) {
        case 'creaElemento':
            $gestoreStoricoOperazioni->aggiungiElemento(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING), filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            echo "ok";
            break;
        case 'eliminaElementoStorico':
            $gestoreStoricoOperazioni->eliminaElemento(filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }